/*
 * Decompiled with CFR 0.152.
 */
package me.angel.blocksfloat;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import me.angel.blocksfloat.config.ModConfig;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2346;
import net.minecraft.class_238;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5819;
import org.joml.Vector3f;

public class FloatingBlocksManager {
    private static boolean enabled = false;
    private static boolean showParticles = false;
    private static boolean pauseOnStanding = false;
    private static boolean floatMobs = false;
    private static int radius = 30;
    private static int intensity = 1;
    private static final int MAX_RADIUS = 50;
    private static final int MAX_INTENSITY = 10;
    private static int maxFloatHeight = 100;
    private static final int MAX_FLOAT_HEIGHT_LIMIT = 200;
    private static final Vector3f PARTICLE_COLOR = new Vector3f(0.5f, 0.8f, 1.0f);
    private static final Map<DimensionBlockPos, class_2680> floatingBlocks = new HashMap<DimensionBlockPos, class_2680>();
    private static final Map<DimensionBlockPos, Integer> blockDelays = new HashMap<DimensionBlockPos, Integer>();
    private static final Map<DimensionBlockPos, DimensionBlockPos> startingPositions = new HashMap<DimensionBlockPos, DimensionBlockPos>();
    private static int moveInterval = 10;
    private static final int MIN_MOVE_INTERVAL = 1;
    private static final int MAX_MOVE_INTERVAL = 100;
    private static final int GRAVITY_BLOCK_DELAY = 3;
    private static int maxRaycastDistance = 64;
    private static final int MAX_RAYCAST_LIMIT = 128;
    private static final Set<class_2248> UNAFFECTED_BLOCKS = Set.of(class_2246.field_9987, class_2246.field_10540, class_2246.field_22423, class_2246.field_10398, class_2246.field_10027, class_2246.field_10613, class_2246.field_10316, class_2246.field_38420, class_2246.field_10260);
    private static ModConfig config;
    private static final Map<UUID, Integer> floatingMobStartY;
    private static final int LEVITATION_STRENGTH = 3;
    private static final class_5819 RANDOM;
    private static final class_2680 AIR_STATE;
    private static final class_2390 OUTLINE_PARTICLE;

    public static void init() {
        config = ModConfig.load();
        enabled = config.isEnabled();
        showParticles = config.isShowParticles();
        pauseOnStanding = config.isPauseOnStanding();
        floatMobs = config.isFloatMobs();
        radius = config.getRadius();
        intensity = config.getIntensity();
        maxFloatHeight = config.getMaxFloatHeight();
        moveInterval = config.getMoveInterval();
        maxRaycastDistance = config.getMaxRaycastDistance();
    }

    public static boolean isEnabled() {
        return enabled;
    }

    public static void setRadius(int newRadius) {
        radius = Math.min(Math.max(1, newRadius), 50);
        config.setRadius(radius);
    }

    public static int getRadius() {
        return radius;
    }

    public static void toggleParticles() {
        showParticles = !showParticles;
        config.setShowParticles(showParticles);
    }

    public static void toggleEnabled() {
        boolean bl = enabled = !enabled;
        if (!enabled) {
            floatingBlocks.clear();
            blockDelays.clear();
            startingPositions.clear();
        }
        config.setEnabled(enabled);
    }

    public static void setIntensity(int newIntensity) {
        intensity = Math.min(Math.max(1, newIntensity), 10);
        config.setIntensity(intensity);
    }

    public static int getIntensity() {
        return intensity;
    }

    public static void setSpeed(int tickInterval) {
        moveInterval = Math.min(Math.max(1, tickInterval), 100);
        config.setMoveInterval(moveInterval);
    }

    public static int getSpeed() {
        return moveInterval;
    }

    public static void setMaxFloatHeight(int height) {
        maxFloatHeight = Math.min(Math.max(1, height), 200);
        config.setMaxFloatHeight(maxFloatHeight);
    }

    public static int getMaxFloatHeight() {
        return maxFloatHeight;
    }

    public static void setRaycastDistance(int distance) {
        maxRaycastDistance = Math.min(Math.max(1, distance), 128);
        config.setMaxRaycastDistance(maxRaycastDistance);
    }

    public static int getRaycastDistance() {
        return maxRaycastDistance;
    }

    public static void togglePauseOnStanding() {
        pauseOnStanding = !pauseOnStanding;
        config.setPauseOnStanding(pauseOnStanding);
    }

    public static boolean isPauseOnStanding() {
        return pauseOnStanding;
    }

    public static void toggleFloatMobs() {
        floatMobs = !floatMobs;
        config.setFloatMobs(floatMobs);
    }

    public static boolean isFloatMobs() {
        return floatMobs;
    }

    public static void tick(class_3218 world) {
        if (!enabled) {
            return;
        }
        FloatingBlocksManager.processFloatingBlocks(world);
        if (showParticles) {
            for (class_1657 player : world.method_18456()) {
                FloatingBlocksManager.showRadiusParticles(world, player);
            }
        }
        if (floatMobs) {
            for (class_1657 player : world.method_18456()) {
                FloatingBlocksManager.processFloatingMobs(world, player);
            }
        }
        int chance = Math.max(1, 20 - intensity * 2);
        int roll = class_5819.method_43047().method_43048(chance);
        if (roll == 0) {
            int attempts = intensity;
            for (class_1657 player : world.method_18456()) {
                for (int i = 0; i < attempts; ++i) {
                    FloatingBlocksManager.tryStartNewBlockFloating(world, (class_3222)player);
                }
            }
        }
    }

    private static void processFloatingBlocks(class_3218 world) {
        if (floatingBlocks.isEmpty()) {
            return;
        }
        String dimension = world.method_27983().method_29177().method_12832();
        HashMap<DimensionBlockPos, class_2680> newPositions = new HashMap<DimensionBlockPos, class_2680>(floatingBlocks.size());
        for (Map.Entry<DimensionBlockPos, class_2680> entry : floatingBlocks.entrySet()) {
            int delay;
            DimensionBlockPos dimPos = entry.getKey();
            if (!dimPos.dimension.equals(dimension)) {
                newPositions.put(dimPos, entry.getValue());
                continue;
            }
            class_2680 state = entry.getValue();
            DimensionBlockPos startDimPos = startingPositions.get(dimPos);
            class_2680 currentState = world.method_8320(dimPos.pos);
            if (!currentState.method_26204().equals(state.method_26204())) {
                blockDelays.remove(dimPos);
                startingPositions.remove(dimPos);
                continue;
            }
            if (startDimPos != null && dimPos.pos.method_10264() - startDimPos.pos.method_10264() >= maxFloatHeight) {
                if (currentState.method_26204().equals(class_2246.field_10124)) continue;
                newPositions.put(dimPos, state);
                continue;
            }
            boolean playerStanding = false;
            if (pauseOnStanding) {
                for (class_1657 player : world.method_18456()) {
                    class_2338 playerStandingBlock = new class_2338((int)Math.floor(player.method_23317()), (int)Math.floor(player.method_23318() - 0.1), (int)Math.floor(player.method_23321()));
                    if (!playerStandingBlock.equals((Object)dimPos.pos)) continue;
                    playerStanding = true;
                    break;
                }
            }
            if (playerStanding) {
                newPositions.put(dimPos, state);
                continue;
            }
            boolean isGravityBlock = currentState.method_26204() instanceof class_2346;
            if (!isGravityBlock && (delay = blockDelays.getOrDefault(dimPos, 0).intValue()) > 0) {
                blockDelays.put(dimPos, delay - 1);
                newPositions.put(dimPos, state);
                continue;
            }
            DimensionBlockPos aboveDimPos = dimPos.up();
            class_2680 aboveState = world.method_8320(aboveDimPos.pos);
            if ((aboveState.method_26215() || aboveState.method_26227().method_15771()) && dimPos.pos.method_10264() < world.method_31600() - maxFloatHeight) {
                for (class_1657 player : world.method_18456()) {
                    class_2338 playerStandingBlock = new class_2338((int)Math.floor(player.method_23317()), (int)Math.floor(player.method_23318() - 0.1), (int)Math.floor(player.method_23321()));
                    if (!playerStandingBlock.equals((Object)dimPos.pos)) continue;
                    class_243 velocity = player.method_18798();
                    player.method_18800(velocity.field_1352, 2.1, velocity.field_1350);
                    player.method_5814(player.method_23317(), player.method_23318() + 1.0, player.method_23321());
                }
                class_2680 currentBlockState = world.method_8320(dimPos.pos);
                world.method_8652(aboveDimPos.pos, currentBlockState, 3);
                world.method_8652(dimPos.pos, class_2246.field_10124.method_9564(), 3);
                newPositions.put(aboveDimPos, currentBlockState);
                if (!isGravityBlock) {
                    blockDelays.put(aboveDimPos, moveInterval);
                }
                if (startDimPos == null) continue;
                startingPositions.put(aboveDimPos, startDimPos);
                continue;
            }
            if (isGravityBlock) continue;
            newPositions.put(dimPos, state);
        }
        floatingBlocks.clear();
        floatingBlocks.putAll(newPositions);
    }

    private static void tryStartNewBlockFloating(class_3218 world, class_3222 player) {
        class_243 playerPos = player.method_19538();
        String dimension = world.method_27983().method_29177().method_12832();
        int playerY = (int)Math.floor(playerPos.field_1351);
        for (int attempt = 0; attempt < 5; ++attempt) {
            int maxY;
            int x = (int)Math.floor(playerPos.field_1352) + RANDOM.method_39332(-radius, radius);
            int z = (int)Math.floor(playerPos.field_1350) + RANDOM.method_39332(-radius, radius);
            for (int y = playerY; y > playerY - maxRaycastDistance; --y) {
                class_2338 checkPos = new class_2338(x, y, z);
                if (!FloatingBlocksManager.isValidBlockToFloat(world, checkPos)) continue;
                FloatingBlocksManager.startFloatingBlock(world, checkPos, dimension);
                return;
            }
            int minY = Math.max(playerY - radius, world.method_31607());
            int randomY = RANDOM.method_39332(minY, maxY = Math.min(playerY + radius, world.method_31600() - maxFloatHeight));
            class_2338 randomPos = new class_2338(x, randomY, z);
            if (FloatingBlocksManager.isValidBlockToFloat(world, randomPos)) {
                FloatingBlocksManager.startFloatingBlock(world, randomPos, dimension);
                return;
            }
            x = (int)Math.floor(playerPos.field_1352) + RANDOM.method_39332(-radius, radius);
            z = (int)Math.floor(playerPos.field_1350) + RANDOM.method_39332(-radius, radius);
            for (int y = playerY; y > playerY - maxRaycastDistance; --y) {
                class_2338 checkPos = new class_2338(x, y, z);
                if (!FloatingBlocksManager.isValidBlockToFloat(world, checkPos)) continue;
                FloatingBlocksManager.startFloatingBlock(world, checkPos, dimension);
                return;
            }
        }
    }

    private static void startFloatingBlock(class_3218 world, class_2338 pos, String dimension) {
        DimensionBlockPos dimPos = new DimensionBlockPos(pos, dimension);
        class_2680 state = world.method_8320(pos);
        floatingBlocks.put(dimPos, state);
        startingPositions.put(dimPos, dimPos);
        boolean isGravityBlock = state.method_26204() instanceof class_2346;
        if (!isGravityBlock) {
            blockDelays.put(dimPos, 0);
        } else {
            blockDelays.put(dimPos, 3);
        }
    }

    private static boolean isValidBlockToFloat(class_3218 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        String dimension = world.method_27983().method_29177().method_12832();
        DimensionBlockPos dimPos = new DimensionBlockPos(pos, dimension);
        return !state.method_26215() && !UNAFFECTED_BLOCKS.contains(state.method_26204()) && !state.method_26227().method_15771() && !floatingBlocks.containsKey(dimPos) && pos.method_10264() < world.method_31600() - maxFloatHeight && (state.method_26214((class_1922)world, pos) >= 0.0f || state.method_45474());
    }

    private static void showRadiusParticles(class_3218 world, class_1657 player) {
        if (!showParticles) {
            return;
        }
        String dimension = world.method_27983().method_29177().method_12832();
        class_243 playerPos = player.method_19538();
        double centerX = Math.floor(playerPos.field_1352) + 0.5;
        double centerY = Math.floor(playerPos.field_1351);
        double centerZ = Math.floor(playerPos.field_1350) + 0.5;
        for (int x = -radius; x <= radius; x += 2) {
            FloatingBlocksManager.spawnOutlineParticle(world, centerX + (double)x, centerY + (double)radius, centerZ + (double)radius);
            FloatingBlocksManager.spawnOutlineParticle(world, centerX + (double)x, centerY + (double)radius, centerZ - (double)radius);
            FloatingBlocksManager.spawnOutlineParticle(world, centerX + (double)radius, centerY + (double)radius, centerZ + (double)x);
            FloatingBlocksManager.spawnOutlineParticle(world, centerX - (double)radius, centerY + (double)radius, centerZ + (double)x);
        }
        for (int y = 0; y <= radius; y += 2) {
            FloatingBlocksManager.spawnOutlineParticle(world, centerX + (double)radius, centerY + (double)y, centerZ + (double)radius);
            FloatingBlocksManager.spawnOutlineParticle(world, centerX + (double)radius, centerY + (double)y, centerZ - (double)radius);
            FloatingBlocksManager.spawnOutlineParticle(world, centerX - (double)radius, centerY + (double)y, centerZ + (double)radius);
            FloatingBlocksManager.spawnOutlineParticle(world, centerX - (double)radius, centerY + (double)y, centerZ - (double)radius);
        }
    }

    private static void spawnOutlineParticle(class_3218 world, double x, double y, double z) {
        world.method_14199((class_2394)OUTLINE_PARTICLE, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    private static void processFloatingMobs(class_3218 world, class_1657 player) {
        if (!floatMobs) {
            return;
        }
        class_238 searchBox = player.method_5829().method_1014((double)radius);
        List nearbyMobs = world.method_8390(class_1309.class, searchBox, entity -> !(entity instanceof class_1657));
        if (nearbyMobs.isEmpty()) {
            return;
        }
        floatingMobStartY.entrySet().removeIf(entry -> {
            class_1297 entity = world.method_14190((UUID)entry.getKey());
            return entity == null || !entity.method_5805() || !(entity instanceof class_1309);
        });
        Iterator iterator = nearbyMobs.iterator();
        while (iterator.hasNext()) {
            class_1309 mob = (class_1309)iterator.next();
            if (!mob.method_6059(class_1294.field_5902)) continue;
            int startY = floatingMobStartY.getOrDefault(mob.method_5667(), (int)mob.method_23318());
            if (mob.method_23318() - (double)startY >= (double)maxFloatHeight) {
                mob.method_6016(class_1294.field_5902);
                floatingMobStartY.remove(mob.method_5667());
            }
            iterator.remove();
        }
        int chance = Math.max(100, 200 - intensity * 10);
        if (!nearbyMobs.isEmpty() && RANDOM.method_43048(chance) == 0) {
            class_1309 selectedMob = (class_1309)nearbyMobs.get(RANDOM.method_43048(nearbyMobs.size()));
            floatingMobStartY.put(selectedMob.method_5667(), (int)selectedMob.method_23318());
            selectedMob.method_6092(new class_1293(class_1294.field_5902, 24000, 3, false, true, true));
        }
    }

    public static void resetToDefaults() {
        config.resetToDefaults();
        enabled = config.isEnabled();
        showParticles = config.isShowParticles();
        radius = config.getRadius();
        intensity = config.getIntensity();
        maxFloatHeight = config.getMaxFloatHeight();
        moveInterval = config.getMoveInterval();
        maxRaycastDistance = config.getMaxRaycastDistance();
    }

    static {
        floatingMobStartY = new HashMap<UUID, Integer>();
        RANDOM = class_5819.method_43047();
        AIR_STATE = class_2246.field_10124.method_9564();
        OUTLINE_PARTICLE = new class_2390(PARTICLE_COLOR, 1.0f);
    }

    private static class DimensionBlockPos {
        final class_2338 pos;
        final String dimension;

        DimensionBlockPos(class_2338 pos, String dimension) {
            this.pos = pos;
            this.dimension = dimension;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DimensionBlockPos that = (DimensionBlockPos)o;
            return this.pos.equals((Object)that.pos) && this.dimension.equals(that.dimension);
        }

        public int hashCode() {
            return Objects.hash(this.pos, this.dimension);
        }

        DimensionBlockPos up() {
            return new DimensionBlockPos(this.pos.method_10084(), this.dimension);
        }
    }
}

